OPTIONS MPRINT;
* .....................................................;
*    ANALYSE HARMONIQUE SUR UNE SUITE DE MESURES       ;
*    OBSERVEES DANS LE TEMPS                           ;
*    AUTEUR : OLIVIER BOVEY                            ;
*             SPICA DECISION                           ;
*             OBOVEY@SPICA-DECISION.FR                 ;
*             WWW.SPICA-DECISION.FR                    ;
*              Copyright 2001 Spica Dcision          ;
*        N.B. L'USAGE DE CETTE MACRO EST ENTIEREMENT        ;
*        LIBRE SOUS RESERVE D'INFORMER L'AUTEUR        ;
*        DES EVENTUELLES AMELIORATIONS QUE LES         ; 
*        UTILISATEURS JUGERONT BON Y APPORTER ET       ; 
*        DE MENTIONNER LA SOURCE SI LES RESULTATS      :
*        DES TRAVAUX QUI L'EXPLOITENT FONT L'OBJET     ;
*        DE PUBLICATION                                ;                               
* .....................................................;

* ................... ;
%MACRO HARMO(FICH=,VART=,VARM=,NBMES=,PAS=,TYPO=TYPO,TITRE=,VCON=,
     DATE=OUI,SORTIE=NON,REF=0,ORIG=0,CUMUL=OUI,NBHARM=0,
     NBCLAS=0);
 * ................... ;

 /* --------------------------------------------------------------------
 FICH      : NOM DU TABLEAU SAS ( 2 NIVEAUX SI PERMANENT)
 VART      : RADICAL DES VARIABLES DE REPERE TEMPOREL ( DAZ, DIR )
 VARM      : RADICAL DES VARIABLES DE MESURE ( FAZ, QIR )
 NBMES     : NOMBRE DE MESURES POSSIBLES
 PAS       : LONGUEUR EN JOUR DES MICRO-PERIODES
 TYPO      : NOM DE LA VARIABLE DE TYPOLOGIE
 CUMUL     : VALEUR CUMULEE OU NON
 TITRE     : TITRE DE L"ANALYSE
 VCON      : LISTE DES VARIABLES DE CONTROLE POUR L"INTERPRETATION
 DATE      : OUI,SI DES DATES SON TRAITEES,NON SINON (DEFAUT OUI)
 SORTIE    : OUI,SI HISTOGRAMME DES VALEURS PROPRES ET CELUI DES
             INDICES DE NIVEAU,NON SINON(DEFAUT NON)
 REF       : REFERENCE EN NOMBRE DE JOURS POUR L"ANNEE TRAITEE(DEFAUT 0)
             (QD LES DATES SONT EXPRIMEES EN NOMBRE DE JOURS A PARTIR
              D"UNE ORIGINE, IL PEUT ETRE NECESSAIRE DE CONVERTIR
              LES DATES AU PREALABLE )
 ORIG      : ORIGNE DES MESURES (DEFAUT 0) EN FORMAT DDMMYY6.
 NBHARM    : NOMBRE D HARMONIQUE A RETENIR, SI 0 ALORS AU PLUS 4
             (DEFAUT 0)
 NBCLAS    : NOMBRE DE CLASSES A RETENIR, CALCUL AUTOMATIQUE SI 0
             (DEFAUT 0) 
 ---------------------------------------------------------------------*/

 %IF &VART= AND &ORIG NE 0 NE %THEN %DO; 
  
  * ................... ;
  /* TRAITEMENT DU CAS OU LES VARIABLES INDICEES REPRESENTENT  
     DIRECTEMENT LES SERIES A ETUDIER
     IL EST NECESSAIRE DE PRECISER LA DATE DE DEBUT 
     D OBSERVATION ( ORIG ) ET LA DUREE ENTRE DEUX
     MESURES ( PAS ) */  
  * ................... ;

  * ................... ;
  /* CONTROLE DES PARAMETRES */
  * ................... ;
  %LET TEST=BON; 
  * ................... ;
  %IF &FICH= %THEN %DO;
   %PUT ERREUR=============> LE NOM DE LA TABLE EST MANQUANT (FICH);
   %LET TEST=FAUX;  
  %END;
  * ................... ;
  %IF &NBMES= %THEN %DO;
   %PUT ERREUR=============> LE NOMBRE DE MESURES EST MANQUANT (NBMES);
   %LET TEST=FAUX;  
  %END;
  * ................... ;
  %IF &PAS= %THEN %DO;
   %PUT ERREUR=============> LE PAS DE TEMPS EST MANQUANT (PAS);
   %LET TEST=FAUX;  
  %END;
  * ................... ;
  %IF &VARM= %THEN %DO;
   %PUT "ERREUR=============> LE RADICAL DES MESURES EST MANQUANT (VARM)";
   %LET TEST=FAUX;  
  %END;
  * ................... ;
  %IF &TEST=FAUX %THEN %GOTO FIN;
  * ................... ;

  * ................... ;
  %LET NBPER =&NBMES; 
  * ................... ;

  * ................... ;
  /* PAR SOUCI DE GENERALISATION DE TOUS LES CAS
     LES VARIABLES D ORIGINE SONT RANGEES DANS LA
     SUITE DES VARIABLES CUMi */ 
  * ................... ;
  DATA FICH(KEEP=IDEN CUM1-CUM&NBPER &VCON);SET &FICH;
  ARRAY MESU [*] &VARM.1-&VARM&NBMES;
  ARRAY CUML [*] CUM1-CUM&NBPER;
  *................;
  DO I=1 TO &NBPER;
   *................;
   CUML(I) = MESU(I); 
   *................;
  END;
  *................;
  RUN;
  * ...................; 

  * ...................; 
  DATA _NULL_;
  CALL SYMPUT("MINT",INPUT("&ORIG",DDMMYY6.));
  RUN;
  * ...................; 

 %END;
 
 %ELSE %DO; 

  * ................... ;
  /* TRAITEMENT DU CAS OU LES MESURES SONT OBSERVEES  
     ALEATOIREMENT DANS LE TEMPS */  
  * ................... ;

  * ................... ;
  /* CONTROLE DES PARAMETRES */
  * ................... ;
  %LET TEST=BON; 
  * ................... ;
  %IF &FICH= %THEN %DO;
   %PUT ERREUR=============> LE NOM DE LA TABLE EST MANQUANT (FICH);
   %LET TEST=FAUX;  
  %END;
  * ................... ;
  %IF &NBMES= %THEN %DO;
   %PUT ERREUR=============> LE NOMBRE DE MESURES EST MANQUANT (NBMES);
   %LET TEST=FAUX;  
  %END;
  * ................... ;
  %IF &PAS= %THEN %DO;
   %PUT ERREUR=============> LE PAS DE TEMPS EST MANQUANT (PAS);
   %LET TEST=FAUX;  
  %END;
  * ................... ;
  %IF &VART= %THEN %DO;
   %PUT ERREUR=============> LE RADICAL DES DATES EST MANQUANT (VART);
   %LET TEST=FAUX;  
  %END;
  * ................... ;
  %IF &VARM= %THEN %DO;
   %PUT ERREUR=============> LE RADICAL DES MESURES EST MANQUANT (VARM);
   %LET TEST=FAUX;  
  %END;
  * ................... ;
  %IF &TEST=FAUX %THEN %GOTO FIN;
  * ................... ;

  * ................... ;
  /* DETERMINATION DE LA PERIODE D OBSERVATION DEDUITE 
     DES DATES D ENREGISTREMENT DES MESURES */  
  * ................... ;
  DATA FICH(DROP= DD);
  SET &FICH(KEEP=IDEN &VART.1-&VART&NBMES &VARM.1-&VARM&NBMES &VCON);
  LENGTH DD 8;
  ARRAY DATT [*] &VART.1-&VART&NBMES;
  %*----------------;
  %IF &ORIG NE 0 %THEN %DO;
   %*----------------;
   %IF &DATE=OUI %THEN %DO;
    DD=INPUT("&ORIG",DDMMYY6.)-&REF;
   %END;
   %*----------------;
   %ELSE %DO;
    DD = &ORIG - &REF;
   %END;
   %*----------------;
   PUT DD=;
   DO I=1 TO DIM(DATT);
    IF 0< DATT(I) < DD THEN DATT(I)=DD;
   END;
   DROP I;
  %END;
  %*----------------;
  MINT=MIN(OF &VART.1-&VART&NBMES);
  MAXT=MAX(OF &VART.1-&VART&NBMES);
  RUN;
  * ................... ;

  * ................... ;
  PROC MEANS DATA=FICH(KEEP=MINT MAXT) MIN MAX NOPRINT;
  VAR MINT MAXT ;
  OUTPUT OUT=MINMAX MIN=MINT A MAX=B MAXT;
  RUN;
  * ................... ;

  * ................... ;
  DATA _NULL_;SET MINMAX;
  LAPS=MAXT-MINT+1;
  NBPER=CEIL(LAPS/&PAS);
  CALL SYMPUT("MINT",MINT);         /* PLUS PETITE DATE OBSERVEE   */
  CALL SYMPUT("MAXT",MAXT);         /* PLUS GRANDE DATE OBSERVEE   */
  CALL SYMPUT("LAPS",LAPS);         /* DUREE D OBSERVATION EN JOUR */
  CALL SYMPUT("NBPER",LEFT(NBPER)); /* NOMBRE DE PERIODES GENEREES */
  STOP;
  RUN;
  * ................... ;

  * ................... ;
  /* CREATION DES TRAJECTOIRES CUMULEES OU NON */
  * ................... ;
  DATA FICH(KEEP=IDEN CUM1-CUM&NBPER &VCON);SET FICH;
  ARRAY MESU [*] &VARM.1-&VARM&NBMES;
  ARRAY DATT [*] &VART.1-&VART&NBMES;
  ARRAY CUML [*] CUM1-CUM&NBPER;
  B1=&MINT;
  J=1;
  CUM0=0;
  DO I=1 TO &NBPER;
   TEST = 1;
   DO WHILE( TEST = 1 AND J <= &NBMES);
    IF B1<= DATT(J) < B1+&PAS & DATT(J) NE . THEN DO;
     %* ------------;
     %IF &CUMUL=OUI %THEN %DO;
      CUM0 = SUM(CUM0,MESU(J));
     %END;
     %* ------------;
     %ELSE %DO;
      CUM0 = MESU(J);
     %END;
     %* ------------;
     J = J + 1;
    END;
    ELSE TEST = 0;
   END;
   CUML(I) = CUM0 ;
   B1=B1+&PAS;
  END;
  RUN;
  * ................... ;
 
 %END;
 
 * .....................................................;
 *      EXTRACTION DES HARMONIQUES                      ;
 * .....................................................;

 * ................... ;
 PROC PRINCOMP OUT=FICH DATA=FICH OUTSTAT=STAT NOPRINT;
 VAR CUM1-CUM&NBPER;
 RUN;
 * ................... ;

 * .....................................................;
 *      EDITIONS DES VALEURS PROPRES                    ;
 * .....................................................;
 %IF %UPCASE(&SORTIE)=OUI %THEN %DO;
  
  DATA VALPR STAT;SET STAT;
  IF _TYPE_ ="EIGENVAL" THEN OUTPUT VALPR;
  IF _TYPE_ ="SCORE" THEN OUTPUT STAT;
  RUN;
  * ................... ;

  * ................... ;
  PROC TRANSPOSE DATA=VALPR PREFIX=VALP ;
  RUN;
  * ................... ;

  * ................... ;
  PROC SORT DATA=_LAST_ ;BY DESCENDING VALP1;
  RUN;
  * ................... ;

  * ................... ;
  DATA VALPR;SET _LAST_ ;
  TITLE1 " &TITRE ";
  TITLE2 "HISTOGRAMME DES VALEURS PROPRES";
  FILE PRINT;
  RETAIN CVAL 0;
  LENGTH KBAR VBAR $ 50 ;
  KBAR="*";
  VBAR=" ";
  DO J=2 TO 50;
   KBAR="*"!!KBAR;
  END;
  PVAL=VALP1/&NBPER;
  M=INT(PVAL*50);
  PVAL=PVAL*100;
  CVAL=CVAL+PVAL;
  IF M NE 0 THEN VBAR=SUBSTR(KBAR,1,M);
  IF _N_ = 1 THEN
   PUT #5 @11 "V. PROPRE" @20 "!" @21 "POURCENT." @30 "!"
   @31 "% CUMUL." @40 "!"
   / @10 "+" 19*"-" @20 "+" 19*"-" @30 "+" 19*"-" @40 "+"
   50*"-" @91 "-" ;
   PUT @11 VALP1 7.4 @20 "!" @21 PVAL 6.2 @30 "!" @31 CVAL 6.2 @40 "!"
   @41 VBAR ;
  RUN;
  * ................... ;

  * ................... ;
  PROC TRANSPOSE DATA=STAT PREFIX=HARM OUT=STAT ;
  RUN;
  * ................... ;

  * ................... ;
  DATA STAT;SET STAT;
  FORMAT T
  %IF &DATE=OUI %THEN %DO;
   DDMMYY6.;
  %END;
  %ELSE %DO;
   4. ;
  %END;
  T=&REF+&MINT+_N_*&PAS;
  RUN;
  * ................... ;

  * ................... ;
  PROC PLOT DATA=STAT;
  TITLE1 " &TITRE ";
  TITLE2 " REPRESENTATION GRAPHIQUE DES QUATRE PREMIERS HARMONIQUES ";
  PLOT HARM1*T="1" HARM2*T="2" HARM3*T="3" HARM4*T="4" /OVERLAY
  VREF=0 VPOS=40;
  RUN;
  * ................... ;

  * ................... ;
  PROC DATASETS;
  DELETE VALPR STAT MINMAX;
  RUN;
  * ................... ;

  * ................... ;
 %END;
 * ................... ;

 * ................... ;
 /* LE NB DE FACTEURS RETENUS EST EGAL AU NOMBRE DE PERIODE - 2 OU
 AU MOINS 4 SI &NBHARM=0 */
 * ................... ;
 DATA _NULL_;
 IF &NBHARM=0 THEN NBCOMP=MIN(&NBPER-2,4);
 ELSE NBCOMP = &NBHARM;
 CALL SYMPUT("NBCOMP",LEFT(NBCOMP));
 STOP;
 RUN;
 * ................... ;

 * ................... ;
 DATA FICH;SET FICH;
 ARRAY COMP [*] PRIN1-PRIN&NBCOMP;
 DO I=1 TO DIM(COMP);
  COMP(I)=COMP(I)*100;
 END;
 RUN;
 * ................... ;

 * ................... ;
 /*
    APPLICATION D UNE CAH (PROC CLUSTER)
 */
 * ................... ;

 PROC CLUSTER DATA=FICH
   METHOD=WARD
   OUTTREE=ARBRE
   NOPRINT
   ;
 VAR PRIN1-PRIN&NBCOMP;
 RUN;

 * ................... ;
 /*
    REMISE EN FORME DES PARAMETRES DE L ARBRE
    POUR AVOIR UNE STRUCTURE :
     CLASSE
     AINE
     BENJAMIN
     INDICE DE NIVEAU (_HEIGHT_)
 */
 * ................... ;

 * ................... ;
 DATA ARBRE; SET ARBRE;
 LENGTH PARENT FILS 8;
 PARENT = SUBSTR(_PARENT_,3);
 FILS   = SUBSTR(_NAME_,3);
 RUN;
 * ................... ;

 * ................... ;
 PROC SORT;BY PARENT FILS;
 RUN;
 * ................... ;

 * ................... ;
 DATA ARBRE_T(KEEP=PARENT BENJ AINE);
 SET ARBRE; BY PARENT FILS;
 *.....;
 LENGTH AINE BENJ 8;
 *.....;
 RETAIN I 0 AINE BENJ ;
 *.....;
 IF FIRST.PARENT THEN DO;
  *.....;
  AINE = .;
  BENJ = .;
  I    = 0;
  *.....;
 END;
 *.....;
 I = I + 1;
 *.....;
 SELECT(I);
  WHEN(1) AINE = FILS;
  WHEN(2) BENJ = FILS;
  OTHERWISE;
 END;
 *.....;
 IF LAST.PARENT THEN OUTPUT;
 *.....;
 RUN;
 * ................... ;

 * ................... ;
 PROC SORT DATA=ARBRE_T; BY PARENT;
 WHERE PARENT NE .;
 RUN;
 * ................... ;

 * ................... ;
 /*
    POUR CHAQUE CLASSE DE L ARBRE ON RECUPERE
     SON NUMERO ( PARENT)
     SON INDICE DE NIVEAU
     LES MOYENNES DES VARIABLES ANALYSEES
 */
 * ................... ;

 * ................... ;
 DATA PARAM; SET ARBRE;
 /* SEULES LES CLASSES SONT CONSERVEES */
 IF SUBSTR(_NAME_,1,2) ="CL";
 PARENT = SUBSTR(_NAME_,3);
 KEEP PARENT _HEIGHT_ PRIN1-PRIN&NBCOMP;
 RUN;
 * ................... ;

 * ................... ;
 PROC SORT DATA=PARAM; BY PARENT;
 WHERE PARENT NE .;
 RUN;
 * ................... ;

 * ................... ;
 /*
    FUSION DES INFORMATIONS ET DETERMINATION
    DU NOMBRE DE CLASSES ( RECHERCHE DU DERNIER
    SAUT SIGNIFICATIF DANS L HISTOGRAMME DES
    INDICES DE NIVEAU ) SI NBCLAS = 0
 */
 * ................... ;

 * ................... ;
 DATA ARBRE_T; MERGE ARBRE_T PARAM;BY PARENT;
 *.....;
 RETAIN TEST 0 NBCLAS 1 ;
 *.....;
 CRIT = (LAG(_HEIGHT_)-_HEIGHT_)/&NBCOMP;
 *.....;
 IF _N_ >1 THEN DO;
  *.....;
  IF TEST = 0 THEN DO;
   *.....;
   IF CRIT >=0.02 THEN NBCLAS + 1 ;
   ELSE TEST = 1;
   *.....;
   %IF &NBCLAS=0 %THEN %DO; 
    CALL SYMPUT('NBCLAS',LEFT(PUT(NBCLAS,4.)));
   %END; 
   *.....;
  END;
  *.....;
 END;
 *.....;
 RUN;
 * ................... ;
 

 * ................... ;
 /*
    DESSIN DE L HISTOGRAMME DES INDICES DE 
    NIVEAU
 */
 * ................... ;

 * ................... ;
 %IF %UPCASE(&SORTIE)=OUI %THEN %DO;
  * ................... ;
  DATA _NULL_;SET ARBRE_T;
  TITLE1 " &TITRE ";
  TITLE2 "HISTOGRAMME DES INDICES DE NIVEAU";
  FILE PRINT;
  RETAIN CVAL 0 INTOT;
  LENGTH KBAR VBAR $ 50 ;
  IF _N_ = 1 THEN DO;
   INTOT = 0;
   DO I = 1 TO NBOBS;
    SET ARBRE_T (KEEP=_HEIGHT_ RENAME=(_HEIGHT_=HEIGHT1))
     POINT=I NOBS=NBOBS;
    INTOT = INTOT + HEIGHT1; 
   END;  
  END;
  KBAR="*";
  VBAR=" ";
  DO J=2 TO 50;
   KBAR="*"!!KBAR;
  END;
  M =INT((_HEIGHT_/INTOT)*50);
  IF M NE 0 THEN VBAR=SUBSTR(KBAR,1,M);
  IF _N_ = 1 THEN
   PUT #5 @11 "CLASSE" @20 "!" @21 " AINE" @30 "!"
   @31 "BENJAMIN" @40 "!" @41 "NIVEAU" @50 "!"
   / @10 "+" 19*"-" @20 "+" 19*"-" @30 "+" 19*"-" @40 "+"
   19*"-" @50 "+"  40*"-" ;
   PUT @11 PARENT 3. @20 "!" @21 AINE 3. @30 "!" @31 BENJ 3. @40 "!"
   @41 _HEIGHT_ 5.3 @50 "!" @51 VBAR ;
  RUN;
  * ................... ;
 %END;
 * ................... ;

 * ................... ;
 /*
    RECUPERATION DES MOYENNES DES CENTRES DES
    CLASSES RETENUES
 */
 * ................... ;

 * ................... ;
 DATA _NULL_;SET ARBRE_T;
 *.....;
 LENGTH LISTE $ 50;
 *.....;
 RETAIN LISTE '0';
 *.....;
 IF PARENT <= &NBCLAS - 1 THEN DO;
  *.....;
  IF AINE > &NBCLAS - 1 THEN LISTE = TRIM(LEFT(LISTE))
     !! ',' !! LEFT(AINE);
  IF BENJ > &NBCLAS - 1 THEN LISTE = TRIM(LEFT(LISTE))
     !! ',' !! LEFT(BENJ);
  *.....;
 END;
 *.....;
 CALL SYMPUT('LISTE',TRIM(LEFT(LISTE)) );
 *.....;
 RUN;
 * ................... ;

 * ................... ;
 DATA MOY (KEEP=PARENT PRIN1-PRIN&NBCOMP);
 *.....;
 SET ARBRE_T;
 *.....;
 IF PARENT IN( &LISTE );
 *.....;
 RUN;
 * ................... ;

 * ................... ;
 /*
    CLASSIFICATION ET OPTIMISATION PAR METHODE
    DES CENTRES MOBILES
 */
 * ................... ;

 * ................... ;
 PROC FASTCLUS DATA=FICH SEED=MOY CLUSTER=CAH MAXC=&NBCLAS
 MAXITER=100 OUT=FICH NOPRINT;
 VAR PRIN1-PRIN&NBCOMP;
 RUN;
 * ................... ;

 * ................... ;
 DATA FICH;SET FICH(RENAME=(CAH=&TYPO));
 RUN;
 * ................... ;

 * ................... ;
 PROC SORT DATA=FICH(KEEP=&TYPO CUM1-CUM&NBPER) OUT=STAT;BY &TYPO;
 RUN;
 * ................... ;

 * ................... ;
 PROC MEANS DATA=STAT MEAN NOPRINT;BY &TYPO;
 VAR CUM1-CUM&NBPER;
 OUTPUT OUT=STAT(DROP=_TYPE_) MEAN=CUM1-CUM&NBPER;
 RUN;
 * ................... ;

 * ................... ;
 DATA _NULL_ ;
 IF 0 THEN SET STAT POINT=_N_ NOBS=COUNT;
 CALL SYMPUT ("NBCLA",LEFT(PUT(COUNT,8.)));
 STOP;
 RUN;
 * ................... ;

 * ................... ;
 PROC TRANSPOSE DATA=STAT PREFIX=&TYPO OUT=STAT ;
 RUN;
 * ................... ;

 * ................... ;
 DATA STAT;SET STAT;
 RETAIN N 0;
 IF _N_ <=2 THEN DELETE;
 ELSE N = N + 1;
 FORMAT T
 %IF &DATE=OUI %THEN %DO;
  DDMMYY6.;
 %END;
 %ELSE %DO;
  4. ;
 %END;
 T=&REF+&MINT+N*&PAS;
 RUN;
 * ................... ;

 * ................... ;
 PROC PLOT DATA=STAT;
 TITLE1 " &TITRE ";
 TITLE2 " TRAJECTOIRES MOYENNES PAR GROUPE ";
 PLOT
 %DO I=1 %TO &NBCLA;
  &TYPO&I*T="&I"
 %END;
 /OVERLAY;
 RUN;
 * ................... ;

 * ................... ;
 %IF &VCON NE %THEN %DO;
  * ................... ;
  PROC TABULATE  DATA=FICH F=7.2 ;
  TITLE1 " &TITRE ";
  TITLE2 "INTERPRETATION DES GROUPES ";
  CLASS &TYPO;
  VAR &VCON ;
  TABLE &TYPO, N PCTN ( &VCON )*(MEAN CV) / RTS=10;
  KEYLABEL MEAN=MOY N="EFF";
  RUN;
  * ................... ;
 %END;
 * ................... ;

 * ................... ;
 DATA FICH;SET FICH(KEEP=IDEN &TYPO);
 RUN;
 * ................... ;

 %FIN:* FIN DE LA MACRO;   

%MEND HARMO;
