*===================================================================;
*                                                                   ;
* MACRO D'OPTIMISATION DES COEFFICIENTS DE REGRESSION PAR           ;
*        ELIMINATION SUCCESSIVE DES POINTS EXTREMES                 ;
*           AUTEUR : OLIVIER BOVEY                                  ;
*                    SPICA DECISION                                 ;
*                    OBOVEY@SPICA-DECISION.FR                       ;
*                    WWW.SPICA-DECISION.FR                          ;
*              Copyright 2002 Spica Dcision                       ;
*        N.B. L'USAGE DE CETTE MACRO EST ENTIEREMENT                ;
*        LIBRE  SOUS   RESERVE  D'INFORMER  L'AUTEUR                ;
*        DES  EVENTUELLES   AMELIORATIONS  QUE   LES                ; 
*        UTILISATEURS  JUGERONT  BON  Y  APPORTER ET                ; 
*        DE MENTIONNER LA SOURCE  SI  LES  RESULTATS                :
*        DES  TRAVAUX QUI  L'EXPLOITENT FONT L'OBJET                ;
*        DE PUBLICATION                                             ;                               
*                                                                   ;
*===================================================================;
*MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM;
%MACRO EPUREG(FICH=,Y=,X=,CONTROLE=NON);
 * ........................... ;

 * ...........................................;
 * FICH     : NOM DU FICHIER DE TRAVAIL       ;
 * Y        : VARIABLE A EXPLIQUER(UNE SEULE) ;
 * X        : LISTE DES VARIABLES EXPLICATIVES;
 * CONTROLE : OUI OU NON SI OUI ALORS  SORTIE ;
 *            DU GRAPHE ITERATION x R2        ; 
 * ...........................................;
 * Les coefficients estims sont stocks dans ;
 * le fichier  COEFF  la dernire  itration ;
 * Les noms  des variables utiliss sont ceux ;
 * des variables auxquelles ils se rapportent ;
 * ...........................................;

 * ........................... ;
 OPTIONS NOMPRINT NONOTES;
 * ........................... ;

 * ........................... ;
 DATA _NULL_;
 ARRAY VARI {*} &Y &X;
 ARRAY EXPL {*} &Y;
 CALL SYMPUT('NBVAR',LEFT(DIM(VARI)));
 IF DIM(EXPL) = 1 THEN CALL SYMPUT('SORTIE','NON');
 ELSE CALL SYMPUT('SORTIE','OUI');
 RUN;
 * ........................... ;
 
 * ........................... ;
 %IF &SORTIE=OUI %THEN %DO;
  %PUT "ERREUR=============> UNE SEULE VARIABLE EXPLICATIVE EST AUTORISEE";
  %GOTO FIN;  
 %END;
 * ........................... ;

 * ........................... ;
 %IF %SUBSTR(&SYSVER,1,1)=8 %THEN %LET INTERCEP=INTERCEPT;
 %ELSE INTERCEP=INTERCEP;
 * ........................... ;

 * ........................... ;
 %LET I=1;
 %LET TEST=NON;
 %LET R2=0;
 * ........................... ;

 * ........................... ;
 %DO %WHILE(&I<=50 AND &TEST=NON);
  * ........................... ;

  * ........................... ;
  * CALCUL DES COMPOSANTES PRINCIPALES;
  * ........................... ;

  * ........................... ;
  PROC PRINCOMP STD NOPRINT DATA=&FICH OUT=PRIN;
  VAR &Y &X;
  RUN;
  * ........................... ;

  * ........................... ;
  * ELIMINATION DES POINTS EXTREMES;
  * ........................... ;

  * ........................... ;
  DATA &FICH(DROP=EFF);SET PRIN;
  RETAIN EFF 0;
  DSQ = USS(OF PRIN1-PRIN&NBVAR);    /* MAHALANOBIS D**2 */
  PROB = 1 - PROBCHI(DSQ,&NBVAR);
  IF PROB>=0.10 THEN DO;
   OUTPUT;
   EFF = EFF+1;
   CALL SYMPUT('EFF',LEFT(EFF));
  END;
  RUN;
  * ........................... ;

  * ........................... ;
  *   CALCUL DE LA REGRESSION   ;
  * ........................... ;

  * ........................... ;
  PROC REG NOPRINT OUTEST=COEF1(KEEP=&X &INTERCEP _RSQ_);
  MODEL &Y = &X /ADJRSQ;
  RUN;
  * ........................... ;

  * ........................... ;
  DATA COEF1;SET COEF1 END=EOF;
  LENGTH ECART 8;
  ITER  = &I;
  EFF   = &EFF;
  ECART = &R2 - _RSQ_;
  IF ROUND(ABS(ECART),0.0001)  <= 0.001 OR ECART>0
    THEN CALL SYMPUT('TEST','OUI');
  IF EOF THEN CALL SYMPUT('R2',PUT(_RSQ_,7.5));
  RUN;
  * ........................... ;

  * ........................... ;
  *  CONCATENATION DES RESULTATS ;
  * ........................... ;

  %IF &I=1 %THEN %DO;
   * ........................... ;
   DATA COEFF_T;SET COEF1;
   RUN;
   * ........................... ;
  %END;
  %ELSE %DO;
   * ........................... ;
   PROC APPEND BASE=COEFF_T DATA=COEF1;
   RUN;
   * ........................... ;
  %END;
  * ........................... ;

  * ........................... ;
  %LET I=%EVAL(&I+1);
  * ........................... ;

  * ........................... ;
  %IF &TEST=NON %THEN %DO;
   * ........................... ;
   * Stockage des coefficients   ;
   * ........................... ;
   DATA COEFF;SET COEF1;
   RUN;
   * ........................... ;
  %END;
  * ........................... ;

  * ........................... ;
 %END;
 * ........................... ;

 * ........................... ;
 *  CONTROLE DES RESULTATS ;
 * ........................... ;

 * ........................... ;
 %IF %UPCASE(&CONTROLE)=OUI %THEN %DO;
   * ........................... ;

  * ........................... ;
  OPTIONS PS=40 LS=135;
  * ........................... ;

  * ........................... ;
  PROC PLOT DATA=COEFF_T;
  TITLE 'OPTIMISATION DU CALCUL DES COEFFICIENTS DE REGRESSION';
  PLOT _RSQ_*ITER EFF*ITER (&X &INTERCEP)*ITER ECART*ITER;
  RUN;
  * ........................... ;

  * ........................... ;
 %END;
 * ........................... ;

 * ........................... ;
 %FIN:OPTIONS MPRINT NOTES;
 * ........................... ;

 * ........................... ;
%MEND EPUREG;
